#import "AccelerometerHelper.h"

#define UNDEFINED_VALUE		999.99f
#define SIGN(x)	((x < 0.0f) ? -1.0f : 1.0f)

@implementation AccelerometerHelper
@synthesize sensitivity;
@synthesize lockout;
@synthesize triggerTime;
@synthesize delegate;

static AccelerometerHelper *sharedInstance = nil;

+(AccelerometerHelper *) sharedInstance {
    if(!sharedInstance) sharedInstance = [[self alloc] init];
    return sharedInstance;
}

- (id) init
{
	if (!(self = [super init])) return self;
	
	self.triggerTime = [NSDate date];
	
	cx = UNDEFINED_VALUE;
	cy = UNDEFINED_VALUE;
	cz = UNDEFINED_VALUE;
	
	lx = UNDEFINED_VALUE;
	ly = UNDEFINED_VALUE;
	lz = UNDEFINED_VALUE;

	px = UNDEFINED_VALUE;
	py = UNDEFINED_VALUE;
	pz = UNDEFINED_VALUE;
	
	self.sensitivity = 0.5f;
	self.lockout = 0.5f;
	
	// Przypisanie delegata dla przyśpieszeniomierza.
	[[UIAccelerometer sharedAccelerometer] setDelegate:self];
	
	return self;
}

- (void) setX: (float) aValue
{
	px = lx;
	lx = cx;
	cx = aValue;
}

- (void) setY: (float) aValue
{
	py = ly;
	ly = cy;
	cy = aValue;
}

- (void) setZ: (float) aValue
{
	pz = lz;
	lz = cz;
	cz = aValue;
}

- (float) dAngle
{
	if (cx == UNDEFINED_VALUE) return UNDEFINED_VALUE;
	if (lx == UNDEFINED_VALUE) return UNDEFINED_VALUE;
	if (px == UNDEFINED_VALUE) return UNDEFINED_VALUE;
	
	// Obliczenia dla pierwszej pary.
	float dot1 = cx * lx + cy * ly + cz * lz;
	float a = ABS(sqrt(cx * cx + cy * cy + cz * cz));
	float b = ABS(sqrt(lx * lx + ly * ly + lz * lz));
	dot1 /= (a * b);
	
	// Obliczenia dla drugiej pary.
	float dot2 = lx * px + ly * py + lz * pz;
	a = ABS(sqrt(px * px + py * py + pz * pz));
	dot2 /= a * b;
	
	// Zwrot różnicy pomiędzy kątami wektorów.
	return acos(dot2) - acos(dot1);
}

- (BOOL) checkTrigger
{
	if (lx == UNDEFINED_VALUE) return NO;
	
	// Sprawdzenie, czy można przetworzyć nowe dane.
	if ([[NSDate date] timeIntervalSinceDate:self.triggerTime] < self.lockout) return NO;
	
	// Pobranie aktualnej zmiany kąta.
	float change = [self dAngle];
	
	// Jeżeli dwie próbki nie zostały jeszcze zebrane, wartością zwrotną jest NO.
	if (change == UNDEFINED_VALUE) return NO;
	
	// Czy obliczona wartość jest większa od granicznej?
	if (change > self.sensitivity)
	{
		self.triggerTime = [NSDate date];
		return YES;
	}
	else return NO;
}

- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration
{
	[self setX:-[acceleration x]];
	[self setY:[acceleration y]];
	[self setZ:[acceleration z]];
	
	// Wszystkie zdarzenia przyśpieszeniomierza.
	if (self.delegate && [self.delegate respondsToSelector:@selector(ping)])
		[self.delegate performSelector:@selector(ping)];
	
	// Wszystkie zdarzenia przyśpieszeniomierza.
	if ([self checkTrigger] && self.delegate && [self.delegate respondsToSelector:@selector(shake)])
	{
		[self.delegate performSelector:@selector(shake)];
	}
}


@end
